% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{fastcluster}
\alias{fastcluster}
\title{fastcluster}
\usage{
fastcluster(
  x,
  k = NULL,
  rdname = "PCA",
  nstart = 3,
  iter.max = 50,
  ndims = NULL,
  nfeatures = 1000,
  verbose = TRUE,
  returnType = c("clusters", "preclusters", "metacells", "graph"),
  ...
)
}
\arguments{
\item{x}{An object of class SCE}

\item{k}{The number of k-means clusters to use in the primary step (should
be much higher than the number of expected clusters). Defaults to 1/10th of
the number of cells with a maximum of 3000.}

\item{rdname}{The name of the dimensionality reduction to use.}

\item{nstart}{Number of starts for k-means clustering}

\item{iter.max}{Number of iterations for k-means clustering}

\item{ndims}{Number of dimensions to use}

\item{nfeatures}{Number of features to use (ignored if `rdname` is given and
the corresponding dimensional reduction exists in `sce`)}

\item{verbose}{Logical; whether to output progress messages}

\item{returnType}{See return.}

\item{...}{Arguments passed to `scater::runPCA` (e.g. BPPARAM or BSPARAM) if
`x` does not have `rdname`.}
}
\value{
By default, a vector of cluster labels. If
`returnType='preclusters'`, returns the k-means pre-clusters. If
`returnType='metacells'`, returns the metacells aggretated by pre-clusters
and the corresponding cell indexes. If `returnType='graph'`, returns the
graph of (meta-)cells and the corresponding cell indexes.
}
\description{
Performs a fast two-step clustering: first clusters using k-means with a very
large k, then uses louvain clustering of the k cluster averages and reports
back the cluster labels.
}
\examples{
sce <- mockDoubletSCE()
sce$cluster <- fastcluster(sce)

}
