% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Test_KS.R
\name{testKS}
\alias{testKS}
\title{testKS}
\usage{
testKS(dat, condition, inclZero = TRUE, numDE = NULL, DEIndex)
}
\arguments{
\item{dat}{Matrix of single-cell RNA-seq data with genes in rows and samples 
in columns.}

\item{condition}{Vector containing the indicator of which condition each 
sample 
 (in the columns of \code{dat}) belongs to.}

\item{inclZero}{Logical indicating whether to include zero in the test of 
different distributions}

\item{numDE}{numeric value for the number of genes that will differ between
two conditions}

\item{DEIndex}{Vector containing the row numbers of the DE genes}
}
\value{
List object containing the significant gene indices, their adjusted 
p-values, and (if DE genes are supplied)
the power and fdr.
}
\description{
Function to perform KS test
}
\examples{

# load toy simulated example ExpressionSet to find KS genes

data(scDatExSim)


# load SingleCellExperiment package to facilitate subset operations

library(SingleCellExperiment)


# check that this object is a member of the ExpressionSet class
# and that it contains 200 samples and 30 genes

class(scDatExSim)
show(scDatExSim)

# perform KS test and obtain adjusted p-values
RES_KS <- testKS(normcounts(scDatExSim), scDatExSim$condition, inclZero=FALSE,
                 numDE=20, DEIndex=1:20)
}
\references{
Korthauer KD, Chu LF, Newton MA, Li Y, Thomson J, Stewart R, 
Kendziorski C. A statistical approach for identifying differential 
distributions
in single-cell RNA-seq experiments. Genome Biology. 2016 Oct 25;17(1):222. 
\url{https://genomebiology.biomedcentral.com/articles/10.1186/s13059-016-
1077-y}
}
