% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SidebySideViolins.R
\name{sideViolin}
\alias{sideViolin}
\title{sideViolin}
\usage{
sideViolin(y, cond, MAP = NULL, logT = TRUE, title.gene = "",
  conditionLabels = unique(cond), axes.titles = TRUE)
}
\arguments{
\item{y}{Numeric vector of data to plot.}

\item{cond}{Vector of condition labels corresponding to elements of \code{x}.}

\item{MAP}{List of MAP partition estimates with conditions as list items and
samples as elements 
(integer indicating which cluster each observation belongs to; zeroes 
belong to cluster 1)}

\item{logT}{Logical that indicates whether to take the log(x+1)
transformation.}

\item{title.gene}{Character vector that contains the gene name
that you are plotting.}

\item{conditionLabels}{Character vector containing the names of
the two conditions.}

\item{axes.titles}{Logical indicating whether or not to include
axes labels on plots.}
}
\value{
ggplot object
}
\description{
Plots two histograms side by side with smoothed density overlay
}
\examples{

# load toy simulated example ExpressionSet to find DD genes

data(scDatExSim)


# load SingleCellExperiment package to facilitate subset operations 

library(SingleCellExperiment)


# plot side by side violin plots for Gene 1 (DE)

sideViolin(normcounts(scDatExSim)[1,], scDatExSim$condition, 
           title.gene=rownames(scDatExSim)[1])


# plot side by side violin plots for Gene 6 (DP)

sideViolin(normcounts(scDatExSim)[6,], scDatExSim$condition, 
           title.gene=rownames(scDatExSim)[6])


# plot side by side violin plots for Gene 11 (DM)

sideViolin(normcounts(scDatExSim)[11,], scDatExSim$condition, 
           title.gene=rownames(scDatExSim)[11])


# plot side by side violin plots for Gene 16 (DB)

sideViolin(normcounts(scDatExSim)[16,], scDatExSim$condition, 
           title.gene=rownames(scDatExSim)[16])

# plot side by side violin plots for Gene 21 (EP)

sideViolin(normcounts(scDatExSim)[21,], scDatExSim$condition, 
           title.gene=rownames(scDatExSim)[21])


# plot side by side violin plots for Gene 26 (EE)

sideViolin(normcounts(scDatExSim)[26,], scDatExSim$condition, 
           title.gene=rownames(scDatExSim)[26])


}
\references{
Korthauer KD, Chu LF, Newton MA, Li Y, Thomson J, Stewart R, 
Kendziorski C. A statistical approach for identifying differential 
distributions
in single-cell RNA-seq experiments. Genome Biology. 2016 Oct 25;17(1):222. 
\url{https://genomebiology.biomedcentral.com/articles/10.1186/s13059-016-
1077-y}
}
