% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutations.R
\name{permMclustGene}
\alias{permMclustGene}
\title{permMclustGene}
\usage{
permMclustGene(y, adjust.perms, nperms, condition, remove.zeroes = TRUE,
  log.transf = TRUE, restrict = TRUE, alpha, m0, s0, a0, b0, C, ref,
  min.size)
}
\arguments{
\item{y}{Numeric data vector for one gene}

\item{adjust.perms}{Logical indicating whether or not to adjust the 
permutation tests for the sample
  detection rate (proportion of nonzero values).  If true, the 
  residuals of a linear model adjusted for 
  detection rate are permuted, and new fitted values are 
  obtained using these residuals.}

\item{nperms}{Number of permutations of residuals to evaulate}

\item{condition}{A character object that contains the name of the column in 
\code{colData} that represents 
 the biological group or condition of interest (e.g. treatment versus 
 control).  Note that this variable should only contain two 
 possible values since \code{scDD} can currently only handle two-group 
 comparisons.  The default option assumes that there
 is a column named "condition" that contains this variable.}

\item{remove.zeroes}{Logical indicating whether zeroes need to be removed 
from \code{y}}

\item{log.transf}{Logical indicating whether the data is in the raw scale 
(if so, will be log-transformed)}

\item{restrict}{Logical indicating whether to perform restricted Mclust 
clustering where close-together clusters are joined.}

\item{alpha}{Value for the Dirichlet concentration parameter}

\item{m0}{Prior mean value for generating distribution of cluster means}

\item{s0}{Prior precision value for generating distribution of cluster means}

\item{a0}{Prior shape parameter value for the generating distribution of 
cluster precision}

\item{b0}{Prior scale parameter value for the generating distribution of 
cluster precision}

\item{C}{Matrix of confounder variables, where there is one row for each
sample and one column for each covariate.}

\item{ref}{one of two possible values in condition;
represents the referent category.}

\item{min.size}{a positive integer that specifies the minimum size of a 
cluster (number of cells) for it to be used
 during the classification step.  Any clusters containing fewer than 
 \code{min.size} cells will be considered an outlier
 cluster and ignored in the classfication algorithm.  The default value
  is three.}
}
\value{
Bayes factor numerator for the current permutation
}
\description{
Function to obtain bayes factor for all permutations of one gene 
(not parallelized; to be used when parallelizing over Genes)
}
\details{
Obtains bayes factor for data vector \code{y} representing one gene
}
\references{
Korthauer KD, Chu LF, Newton MA, Li Y, Thomson J, Stewart R,
 Kendziorski C. A statistical approach for identifying differential
  distributions
in single-cell RNA-seq experiments. Genome Biology. 2016 Oct 25;17(1):222. 
\url{https://genomebiology.biomedcentral.com/articles/10.1186/s13059-016-
1077-y}
}
