% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{regexLocate}
\alias{regexLocate}
\title{Locate occurrences of regular expression}
\usage{
regexLocate(regex, seqs, showMatch = FALSE)
}
\arguments{
\item{regex}{character vector or XStringSet of regular expressions
to search for}

\item{seqs}{named character vector or XStringSet of sequences in
which to locate regex}

\item{showMatch}{logical value; if true add additional column to
output indicating what the exact regex match for each
occurrence (can be slow)}
}
\value{
If only a single regex is searched for: data.frame with two
    columns: `seqid' containing the name of the sequence from seqs
    in which the regex was found and `location' giving the 1-based
    position at which the regex was found. If length(regex) greater
    than one, adds additional column `regex' indicating the name of
    the regex located.
}
\description{
Find locations of matches of a regular expression (or vector of
regular expressions) in each element of a named character
vector. Not case sensitive.
}
\examples{
data(simulatedSeqs)
reLoci <- regexLocate('AAAAA|TTTTT', simulatedSeqs)

}
