% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethodSangerContig.R
\name{SangerContig-class-generateReportSC}
\alias{SangerContig-class-generateReportSC}
\alias{generateReportSC,SangerContig-method}
\title{generateReportSC}
\usage{
\S4method{generateReportSC}{SangerContig}(
  object,
  outputDir,
  includeSangerRead = TRUE,
  colors,
  navigationAlignmentFN = NULL
)
}
\arguments{
\item{object}{A SangerContig S4 instance.}

\item{outputDir}{The output directory of the generated HTML report.}

\item{includeSangerRead}{The parameter that decides whether to include SangerRead level report. The value is \code{TRUE} or \code{FALSE} and the default is \code{TRUE}.}

\item{colors}{A vector for users to set the colors of (A, T, C, G, else). 
There are three options for users to choose from. 
  1. "default":  (green, blue, black, red, purple). 
  2. "cb_friendly":  ((0, 0, 0), (199, 199, 199), (0, 114, 178), (213, 94, 0), (204, 121, 167)). 
  3. Users can set their own colors with a vector with five elements.}

\item{navigationAlignmentFN}{The internal parameter passed to HTML report. Users should not modify this parameter on their own.}
}
\value{
The output absolute path to the SangerContig's HTML file.
}
\description{
A SangerContig method which generates final reports of the SangerContig instance.
}
\examples{
data("sangerContigData")
\dontrun{
generateReportSC(sangerContigData)
generateReportSC(sangerContigData, colors="cb_friendly")}
}
