% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{sracipeUniqueStates}
\alias{sracipeUniqueStates}
\alias{sracipeUniqueStates,RacipeSE-method}
\title{A method for grabbing unique states}
\usage{
sracipeUniqueStates(.object)

\S4method{sracipeUniqueStates}{RacipeSE}(.object)
}
\arguments{
\item{.object}{RacipeSE object generated by \code{\link{sracipeSimulate}}
function.}
}
\value{
\code{list} object. Element i of the list is a data frame containing
the unique expressions of model i in the input RacipeSE object
}
\description{
This method selects the unique expression states for every model
in an sRACIPE object. The method of evaluating uniqueness is the same as in
the main \code{\link{sracipeSimulate}} function.Non-converged expressions are
filtered out using the simulation convergence data. This method should only be
used for deterministic simulations with nIC > 1.
}
\section{Related Functions}{


\code{\link{sracipeSimulate}},  \code{\link{sracipeKnockDown}},
\code{\link{sracipeConvergeDist}},  \code{\link{sracipePlotData}}
}

\examples{
data("demoCircuit")
\dontrun{
rSet <- sRACIPE::sracipeSimulate(circuit = demoCircuit, numModels = 20,
integrateStepSize = 0.1, numConvergenceIter = 30)
stateList <- sracipeUniqueStates(rSet)
comginedStates <- do.call(cbind, stateList)
}
}
