% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{sracipePlotParamBifur}
\alias{sracipePlotParamBifur}
\alias{sracipePlotParamBifur,RacipeSE-method}
\title{Parameter bifurcation plots}
\usage{
sracipePlotParamBifur(
  .object,
  paramName,
  data = NULL,
  paramValue = NULL,
  assignedClusters = NULL,
  plotToFile = FALSE
)

\S4method{sracipePlotParamBifur}{RacipeSE}(
  .object,
  paramName,
  data = NULL,
  paramValue = NULL,
  assignedClusters = NULL,
  plotToFile = FALSE
)
}
\arguments{
\item{.object}{RacipeSE object generated by
\code{\link{sracipeSimulate}} function.}

\item{paramName}{character. The name of the parameter to be plotted.}

\item{data}{(optional) dataframe. Default rSet geneExpression. The data
to be plotted. For example, use rSet$stochasticSimulations$[noise] to plot
the stochastic data.}

\item{paramValue}{(optional) Dataframe. The parameter values if rSet$params
is not to be used.}

\item{assignedClusters}{(optional) Dataframe. The cluster assignment of data.}

\item{plotToFile}{(optional) logical. Default \code{FALSE}. Whether to save
plots to a file.}
}
\value{
none
}
\description{
Plot the expression of the genes against parameter values
to understand the effect of parameters on the gene expressions.
}
\examples{
data("demoCircuit")
\dontrun{
rSet <- sRACIPE::sracipeSimulate(circuit = demoCircuit, numModels = 100,
plots=FALSE, plotToFile = FALSE)
rSet <- sRACIPE::sracipeNormalize(rSet)
sracipePlotParamBifur(rSet, "G_A")
}

}
