% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{sracipePlotData}
\alias{sracipePlotData}
\alias{sracipePlotData,RacipeSE-method}
\title{Plot sRACIPE data}
\usage{
sracipePlotData(
  .object,
  plotToFile = FALSE,
  nClusters = 2,
  heatmapPlot = TRUE,
  pcaPlot = TRUE,
  umapPlot = TRUE,
  networkPlot = TRUE,
  clustMethod = "ward.D2",
  col = col,
  distType = "euclidean",
  assignedClusters = NULL,
  corMethod = "spearman",
  ...
)

\S4method{sracipePlotData}{RacipeSE}(
  .object,
  plotToFile = TRUE,
  nClusters = 2,
  heatmapPlot = TRUE,
  pcaPlot = TRUE,
  umapPlot = TRUE,
  networkPlot = TRUE,
  clustMethod = "ward.D2",
  col = col,
  distType = "euclidean",
  assignedClusters = NULL,
  corMethod = "spearman",
  ...
)
}
\arguments{
\item{.object}{List A list returned by \code{\link{sracipeSimulate}} function}

\item{plotToFile}{(optional) logical. Default \code{FALSE}. Whether to save
plots to a file.}

\item{nClusters}{(optional) Integer. Default 2. Expected number of clusters
in the simulated data. Hierarchical clustering will be used to cluster the
data and the the models will be colored in UMAP and PCA plots according to
these clustering results. The clusters can be also supplied using
\code{assignedClusters}.}

\item{heatmapPlot}{(optional) logical. Default \code{TRUE}. Whether to plot
hierarchichal clustering.}

\item{pcaPlot}{(optional) logical. Default \code{TRUE}. Whether to plot PCA
embedding.}

\item{umapPlot}{(optional) logical. Default \code{TRUE}. Whether to plot
UMAP embedding}

\item{networkPlot}{(optional) logical. Default \code{TRUE}. Whether to plot
the network.}

\item{clustMethod}{(optional) character. Default \code{"ward.D2"}. Clustering
method for heatmap. See \code{\link[gplots]{heatmap.2}}}

\item{col}{(optional) Color palette}

\item{distType}{(optional) Distance type.  Used only if specified
explicitly. Otherwise, 1-cor is used. See \code{\link[stats]{dist}},
\code{\link[stats]{hclust}}}

\item{assignedClusters}{vector integer or character. Default NULL.
Cluster assignment of models.}

\item{corMethod}{(optional) character. Default \code{"spearman"}. Correlation
method for distance function.}

\item{...}{Other arguments}
}
\value{
\code{RacipeSE} object
}
\description{
Plots heatmap, pca, umap of the data simulated using sRACIPE
}
\section{Related Functions}{


\code{\link{sracipeSimulate}},  \code{\link{sracipeKnockDown}},
\code{\link{sracipeOverExp}},  \code{\link{sracipePlotData}},
}

\examples{
data("demoCircuit")
\dontrun{
rSet <- sRACIPE::sracipeSimulate(circuit = demoCircuit, numModels = 20,
integrateStepSize = 0.1, simulationTime = 30)
rSet <- sracipePlotData(rSet)
}
}
