% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqt-generics.R, R/rqt-methods.R
\docType{methods}
\name{covariates}
\alias{covariates}
\alias{covariates,rqt-method}
\title{This function performs an access to covariates}
\usage{
covariates(obj)

\S4method{covariates}{rqt}(obj)
}
\arguments{
\item{obj}{An object of \code{rqt} class.}
}
\value{
covariates returns the covariates
}
\description{
An accessor to covariates
}
\examples{
data <- data.matrix(read.table(system.file("extdata/test.bin1.dat", 
package="rqt"), header=TRUE))
pheno <- data[,1]
geno <- data[, 2:dim(data)[2]]
colnames(geno) <- paste(seq(1, dim(geno)[2]))
geno.obj <- SummarizedExperiment(geno)
obj <- rqt(phenotype=pheno, genotype=geno.obj)
covariates(obj)
}
