% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meltingBatch.R
\name{meltingBatch}
\alias{meltingBatch}
\title{Compute melting temperature of multiple nucleic acid duplexes in batch}
\usage{
meltingBatch(
  sequence,
  comp.sequence = NULL,
  environment.out = TRUE,
  options.out = TRUE,
  message.out = TRUE,
  ...
)
}
\arguments{
\item{sequence}{A character vector of 5' to 3' sequences of one strand of the
nucleic acid duplex (\strong{Note:} Uridine and thymidine are not
considered as identical).}

\item{comp.sequence}{A character vector of 3' to 5' complementary sequences
of the nucleic acid duplex. Complementary sequences are computed by
default, but need to be specified in case of mismatches, inosine(s) or
hydroxyadenine(s) between the two strands.}

\item{environment.out}{logical. If \code{TRUE}, gives the melting temperature
computation environment details in the output. Default is \code{TRUE}.}

\item{options.out}{logical. If \code{TRUE}, gives the details about the
options (default or user specified) used for melting temperature
computation in the output. Default is \code{TRUE}.}

\item{message.out}{logical. If \code{TRUE}, gives the error and/or warning
messages, if any in the output. Default is \code{TRUE}.}

\item{...}{Arguments for melting temperature computation (See
\code{\link[rmelting]{melting}}).}
}
\value{
A data frame of the melting temperature computation results along
  with the details of environment, options and messages if specified by the
  arguments \code{environment.out}, \code{options.out} and \code{message.out}
  respectively.
}
\description{
Compute the enthalpy and entropy of helix-coil transition, and then the
melting temperature of multiple nucleic acid duplexes in batch.
}
\examples{
sequence <- c("CAAAAAG", "CAAAAAAG", "TTTTATAATAAA", "CCATCGCTACC",
              "CAAACAAAG", "CCATTGCTACC", "CAAAAAAAG", "GTGAAC", "AAAAAAAA",
              "CAACTTGATATTATTA", "CAAATAAAG", "GCGAGC", "GGGACC",
              "CAAAGAAAG", "CTGACAAGTGTC", "GCGAAAAGCG")

meltingBatch(sequence, nucleic.acid.conc = 0.0004,
             hybridisation.type = "dnadna", Na.conc = 1)

seq <- c("GCAUACG", "CAGUAGGUC", "CGCUCGC", "GAGUGGAG", "GACAGGCUG",
         "CAGUACGUC", "GACAUCCUG", "GACCACCUG", "CAGAAUGUC", "GCGUCGC",
         "CGUCCGG", "GACUCUCUG", "CAGCUGGUC", "GACUAGCUG", "CUCUGCUC",
         "GCGUCCG", "GUCCGCG", "CGAUCAC", "GACUACCUG", "GACGAUCUG")

comp.seq <- c("CGUUUGC", "GUCGGCCAG", "GCGUGCG", "CUCUUCUC", "CUGUGCGAC",
              "GUCGGGCAG", "CUGUUGGAC", "CUGGGGGAC", "GUCUGGCAG", "CGCUGCG",
              "GCUGGCC", "CUGAUAGAC", "GUCGUUCAG", "CUGAGCGAC", "GAGUUGAG",
              "CGCUGGC", "CUGGCGC", "GCUUGUG", "CUGAGGGAC", "CUGCCAGAC")

meltingBatch(sequence = seq, comp.seq = comp.seq, nucleic.acid.conc = 0.0004,
             hybridisation.type = "rnarna", Na.conc = 1,
             method.singleMM = "tur06")

}
\seealso{
\code{\link[rmelting]{melting}}
}
