% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rifi_penalties.r
\name{rifi_penalties}
\alias{rifi_penalties}
\title{\subsection{=========================================================================
rifi_penalties}{

rifi_penalties wraps conveniently all penalty steps
}}
\usage{
rifi_penalties(
  inp,
  details = FALSE,
  viz = FALSE,
  top_i = 25,
  cores = 1,
  dpt = 1,
  smpl_min = 10,
  smpl_max = 100,
  sta_pen = 0.5,
  end_pen = 4.5,
  rez_pen = 9,
  sta_pen_out = 0.5,
  end_pen_out = 4.5,
  rez_pen_out = 9
)
}
\arguments{
\item{inp}{SummarizedExperiment: the input data frame with correct format.}

\item{details}{logical: whether to return the penalty objects or just the
logbook.}

\item{viz}{logical: whether to visualize the output or not. Default is FALSE}

\item{top_i}{integer: the number of top results visualized. Default is all.}

\item{cores}{integer: the number of assigned cores for the task.}

\item{dpt}{integer: the number of times a full iteration cycle is repeated
with a more narrow range based on the previous cycle. Default is 2.}

\item{smpl_min}{integer: the smaller end of the sampling size. Default is 10.}

\item{smpl_max}{integer: the larger end of the sampling size. Default is 100.}

\item{sta_pen}{numeric: the lower starting penalty. Default is 0.5.}

\item{end_pen}{numeric: the higher starting penalty. Default is 4.5.}

\item{rez_pen}{numeric: the number of penalties iterated within the penalty
range. Default is 9.}

\item{sta_pen_out}{numeric: the lower starting outlier penalty. Default is
0.5.}

\item{end_pen_out}{numeric: the higher starting outlier penalty. Default is
3.5.}

\item{rez_pen_out}{numeric: the number of outlier penalties iterated within
the outlier penalty range. Default is 7.}
}
\value{
The SummarizedExperiment object: with the penalties in the
logbook added to the metadata. Also adds logbook_details if details is TRUE,
and plots the penalties if viz is TRUE.
}
\description{
rifi_penalties wraps the functions:
\enumerate{
\item make_pen,
\item viz_pen_obj
}
}
\examples{
data(fit_minimal)
rifi_penalties(
  inp = fit_minimal, details = FALSE, viz = FALSE,
  top_i = 25, cores = 2, dpt = 1, smpl_min = 10, smpl_max = 100,
  sta_pen = 0.5, end_pen = 4.5, rez_pen = 9, sta_pen_out = 0.5,
  end_pen_out = 4.5, rez_pen_out = 9
)

}
\seealso{
\code{make_pen}

\code{viz_pen_obj}
}
