% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_df.r
\name{make_df}
\alias{make_df}
\title{\subsection{=========================================================================
make_df}{

make_df adds important columns to the SummarizedExperiment object
}}
\usage{
make_df(inp, cores = 1, bg = 0, rm_FLT = TRUE)
}
\arguments{
\item{inp}{SummarizedExperiment: the (checked) input.}

\item{cores}{integer: the number of assigned cores for the task.}

\item{bg}{numeric: threshold over which the last timepoint has to be fitted
with the above background mode.}

\item{rm_FLT}{logical: remove IDs where all replicates are marked as
filtered. Default is FALSE.}
}
\value{
the SummarizedExperiment object: with intensity, probe_TI and
flag added to the rowRanges.
}
\description{
'make_df' adds to the SummarizedExperiment object with the columns:
"intensity", "probe_TI" and "flag".
}
\details{
The replicates are collapsed into their respective means.

"intensity" is the mean intensity from time point 0.

"probe_TI" is a value needed for the distribution for the different fitting
models.

"flag" contains information or the distribution for the different fitting
models.

Probes that don't reach the background level expression are flagged as
"\emph{ABG}" ("above background"). This is only needed for microarray data and
is controlled by the bg  parameter. The default for bg = 0, resulting in all
probes to be above background (0 is advised for RNAseq data).

Probes where all replicates were filtered in the optional filtration step
can be fully removed by rm_FLT = TRUE! If you wish to keep all information
in the assay set to FALSE!
}
\examples{
data(preprocess_minimal)
make_df(inp = preprocess_minimal, cores = 2, bg = 0, rm_FLT = TRUE)

}
