% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finding_PDD.r
\name{finding_PDD}
\alias{finding_PDD}
\title{\subsection{=========================================================================
finding_PDD}{

finding_PDD   Flags potential candidates for post transcription decay
}}
\usage{
finding_PDD(inp, cores = 1, pen = 2, pen_out = 1, thrsh = 0.001)
}
\arguments{
\item{inp}{SummarizedExperiment: the input.}

\item{cores}{integer: the number of assigned cores for the task}

\item{pen}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer fragments. Advised to be kept at 2.
Default is 2.}

\item{pen_out}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer possible outliers. Advised to be kept at 1.
Default is 1.}

\item{thrsh}{numeric: an internal parameter that allows fragments with slopes
steeper than the thrsh to be flagged with '\emph{PDD}'. Higher values result in
fewer candidates. Advised to be kept at 0.001. Default is 0.001.}
}
\value{
The SummarizedExperiment object: with "\emph{PDD}" added to the flag
column.
}
\description{
'finding_PDD' uses 'score_fun_linear_PDD' to make groups by the difference
to the slope. The slope is further checked for steepness to decide for PDD.
'\emph{PDD}' is added to the 'flag' column.
Post transcription decay is characterized by a strong decrease of intensity
by position.
The rowRanges need to contain at least 'ID', 'intensity', 'position' and
'position_segment'!
}
\examples{
data(preprocess_minimal)
finding_PDD(inp = preprocess_minimal, cores = 2, pen = 2,
pen_out = 1, thrsh = 0.001)

}
