% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe_summary_events_ps_itss.r
\name{dataframe_summary_events_ps_itss}
\alias{dataframe_summary_events_ps_itss}
\title{\subsection{=========================================================================
dataframe_summary_events_ps_itss}{

dataframe_summary_events_ps_itss  creates one table with all events between
the segments.
}}
\usage{
dataframe_summary_events_ps_itss(data, data_annotation)
}
\arguments{
\item{data}{SummarizedExperiment: the input data frame with correct format.}

\item{data_annotation}{dataframe: dataframe from processed gff3 file.}
}
\value{
\describe{
\item{event:}{String, event type.}
\item{p_value:}{Integer, p_value of the event.}
\item{p_adjusted:}{Integer, p_value adjusted.}
\item{event_position:}{Integer, the position middle between 2 fragments
with an event.}
\item{velocity_ratio:}{Integer, the ratio value of velocity from 2 delay
fragments.}
\item{feature_type:}{String, region annotation covering the fragments.}
\item{gene:}{String, gene annotation covering the fragments.}
\item{locus_tag:}{String, locus_tag annotation covering the fragments.}
\item{strand:}{Boolean. The bin/probe specific strand (+/-).}
\item{TU:}{String, The overarching transcription unit.}
\item{segment_1:}{String, the first segment of the event, includes the
segment, TU, delay fragment in case of ps or iTSS_I. The rest of the
events include HL fragment and could be extended intensity fragment.}
\item{segment_2:}{String, the second fragment of the two of fragments
subjected to analysis.}
\item{event_duration:}{Integer, the difference (min) between 2 delay
fragment when ps or iTSS_I happen.}
\item{gap_fragments:}{Integer, length in position (nt), calculated by the
difference between the last position of the first fragment and the first
position of the second fragment.}
\item{features:}{Integer, number of fragements involved on the event}
}
}
\description{
The dataframe_summary_events_ps_itss creates one table with the following
columns: event, features, p_value, event_position, event_duration, position,
region, gene, locus_tag, strand, TU, segment_1, segment_2, length,
velocity_ratio.
}
\examples{
data(stats_minimal)
if(!require(SummarizedExperiment)){
suppressPackageStartupMessages(library(SummarizedExperiment))
}
dataframe_summary_events_ps_itss(data = stats_minimal,
data_annotation = metadata(stats_minimal)$annot[[1]])

}
