% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe_summary_TI.r
\name{dataframe_summary_TI}
\alias{dataframe_summary_TI}
\title{\subsection{=========================================================================
dataframe_summary_TI}{

dataframe_summary_TI creates one table with all TI fragments,p_value and
the coordinates
}}
\usage{
dataframe_summary_TI(data, input)
}
\arguments{
\item{data}{SummarizedExperiment: the input data frame with correct format.}

\item{input}{dataframe: dataframe from event_dataframe function.}
}
\value{
\describe{
\item{event:}{String, event type, transcription interference.}
\item{TI_fragment:}{String, the fragment with TI.}
\item{TI_termination_factor:}{String, the factor of TI fragment.}
\item{p_value:}{Integer, p_value of the event.}
\item{p_adjusted:}{Integer, p_value adjusted.}
\item{feature_type:}{String, region annotation covering the fragments.}
\item{gene:}{String, gene annotation covering the fragments.}
\item{locus_tag:}{String, locus_tag annotation covering the fragments.}
\item{strand:}{Boolean. The bin/probe specific strand (+/-).}
\item{TU:}{String, The overarching transcription unit.}
\item{Features:}{Integer, The number of segments within the TI.}
\item{event_position:}{Integer, the position middle between 2 TI
fragments.}
\item{position_1:}{String, the first position of TI fragment, if 2
fragments, first position is from the first fragment.}
\item{position_2:}{String, the last position of TI fragment, if 2
fragments, last position is from the second fragment.}
}

WIP
}
\description{
The dataframe_summary creates one table with the following columns: event,
TI_fragment, TI_factor, TI_fragments_TU, p_value, feature_type,
gene, locus_tag, strand, TU, features, event_position, position_1 and
position_2.
}
\examples{
data(stats_minimal)
data(res_minimal)
dataframe_summary_TI(data = stats_minimal, input = res_minimal)

}
