% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_fun.r
\name{loading_fun}
\alias{loading_fun}
\title{loading_fun loads the data of all conditions}
\usage{
loading_fun(data1, data2, data3)
}
\arguments{
\item{data1}{data frame from rifi_stats of one condition}

\item{data2}{data frame from rifi_stats of other condition}

\item{data3}{data frame from differential gene expression at time 0}
}
\value{
A list of two data frames with joined columns from differential
expression and output of rifi_stats with the corresponding columns: ID with
position, strand, intensity, probe_TI, flag, position_segment, delay,
half_life, TI_termination_factor, delay_fragment, velocity_fragment,
intercept, slope, HL_fragment, HL_mean_fragment, intensity_fragment,
intensity_mean_fragment, TU, TI_termination_fragment,
TI_mean_termination_factor, seg_ID, pausing_site, iTSS_I, ps_ts_fragment,
event_ps_itss_p_value_Ttest, p_value_slope, delay_frg_slope, velocity_ratio,
event_duration, event_position, FC_HL, FC_fragment_HL, p_value_HL,
FC_intensity, FC_fragment_intensity, p_value_intensity, FC_HL_intensity,
FC_HL_intensity_fragment, FC_HL_adapted, synthesis_ratio,
synthesis_ratio_event, p_value_Manova, p_value_TI, cdt (condition),
logFC_int (log2FC(intensity)), P.Value of log2FC(intensity).
}
\description{
loading_fun extract outputs from rifi_stats of all conditions and join
each data to the differential expression table. The differential gene
expression at time 0 needs to be run separately.
The columns log2FC, p_value adjusted, position and strand are extracted and
saved to a data frame. loading_fun joins the differential gene expression
table and the output from rifi statistics into one data frame.
}
\examples{
data(stats_se_cdt1)
data(stats_se_cdt2)
data(differential_expression)
inp_s <-
loading_fun(stats_se_cdt1, stats_se_cdt2, differential_expression)[[1]]
inp_f <-
loading_fun(stats_se_cdt1, stats_se_cdt2, differential_expression)[[2]]

}
