% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ribo_class.R, R/ribo_methods.R, R/create_ribo.R
\docType{class}
\name{Ribo-class}
\alias{Ribo-class}
\alias{show,Ribo-method}
\alias{path,Ribo-method}
\alias{experiments,Ribo-method}
\alias{format_version,Ribo-method}
\alias{reference,Ribo-method}
\alias{length_min,Ribo-method}
\alias{length_max,Ribo-method}
\alias{left_span,Ribo-method}
\alias{right_span,Ribo-method}
\alias{metagene_radius,Ribo-method}
\alias{length_offset,Ribo-method}
\alias{has_metadata,Ribo-method}
\alias{experiment_info,Ribo-method}
\alias{transcript_info,Ribo-method}
\alias{alias_hash,Ribo-method}
\alias{original_hash,Ribo-method}
\alias{Ribo}
\alias{experiments}
\alias{alias_hash}
\alias{experiment_info}
\alias{format_version}
\alias{has_metadata}
\alias{left_span}
\alias{length_max}
\alias{length_min}
\alias{length_offset}
\alias{metagene_radius}
\alias{original_hash}
\alias{path}
\alias{reference}
\alias{right_span}
\alias{transcript_info}
\title{Ribo Class}
\usage{
\S4method{show}{Ribo}(object)

\S4method{path}{Ribo}(object)

\S4method{experiments}{Ribo}(object)

\S4method{format_version}{Ribo}(object)

\S4method{reference}{Ribo}(object)

\S4method{length_min}{Ribo}(object)

\S4method{length_max}{Ribo}(object)

\S4method{left_span}{Ribo}(object)

\S4method{right_span}{Ribo}(object)

\S4method{metagene_radius}{Ribo}(object)

\S4method{length_offset}{Ribo}(object)

\S4method{has_metadata}{Ribo}(object)

\S4method{experiment_info}{Ribo}(object)

\S4method{transcript_info}{Ribo}(object)

\S4method{alias_hash}{Ribo}(object)

\S4method{original_hash}{Ribo}(object)

Ribo(path, rename = NULL)
}
\arguments{
\item{object}{Ribo object}

\item{path}{The path to the .ribo file}

\item{rename}{A function that renames the original transcript or an already generated
character vector of aliases}
}
\value{
Returns an S4 object of class "Ribo" containing a path to the HDF5 file,
        various attributes in the root folder, and information about the transcripts 
        such as names and lengths
}
\description{
The Ribo object serves as the main utility vehicle for the ribor package.
Specifically, it allows the user to interface with a .ribo file in the R
ribor rely on the Ribo object to read, visualize, and inspect the
contents of the .ribo file. 
The information stored in this object include the .ribo file path, the 
list of experiments, the format version, the reference model, the minimum
read length, maximum read length, the left span, the right span, and 
other transcript information.
}
\details{
Note that the path parameter takes in a file path and stores it. While 
using the package, be sure to not to move or change the location of the 
.ribo file. The default names of the transcripts may be difficult to use depending on the 
settings used to generate the .ribo file. As a result, we have provided a 
rename parameter that integrates well with the Appris reference transcriptome.
Users may also define a simple function that processes a given default 
transcript name in a one-to-one manner to another custom alias.
}
\examples{
file.path <- system.file("extdata", "sample.ribo", package = "ribor")
sample <- Ribo(file.path)

show(sample)

#generate a ribo object with transcript nicknames/aliases
file.path <- system.file("extdata", "HEK293_ingolia.ribo", package = "ribor")
sample <- Ribo(file.path, rename = rename_default )
}
\seealso{
If a ribo object is already generated but aliases want to be added or updated, use the
\code{\link{set_aliases}} function.
}
