% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_plotTree.R
\name{plotTree}
\alias{plotTree}
\title{Plot a Phylogenetic Tree from a Distance Matrix}
\usage{
plotTree(distance_matrix, ...)
}
\arguments{
\item{distance_matrix}{A numeric, symmetric matrix of pairwise distances
(zeros on the diagonal).}

\item{...}{Additional arguments passed to \code{\link[stats]{plot.hclust}}.}
}
\value{
Invisibly returns the \code{\link[stats]{hclust}} object.
}
\description{
Generates a simple phylogenetic tree/dendrogram from a pairwise distance
matrix using hierarchical clustering (complete linkage by default).
}
\details{
The function converts the matrix to a \code{\link[stats]{dist}} object,
performs \code{\link[stats]{hclust}} with \code{method = "complete"}, and
plots the resulting dendrogram.
}
\examples{
# Example using built-in dataset
test <- system.file("extdata", "input_aln.fasta", package = "rhinotypeR")
fastaD <- Biostrings::readDNAStringSet(test)

# Compute pairwise distances
dist_mat <- pairwiseDistances(fastaD)

# Plot tree
plotTree(dist_mat, lwd = 2)

}
\seealso{
\code{\link{pairwiseDistances}}, \code{\link{plotDistances}}

Other visualization: 
\code{\link{SNPeek}()},
\code{\link{plotAA}()},
\code{\link{plotDistances}()},
\code{\link{plotFrequency}()}
}
\concept{visualization}
