% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_plotFrequency.R
\name{plotFrequency}
\alias{plotFrequency}
\title{Plot Frequency of Assigned Rhinovirus Types}
\usage{
plotFrequency(
  assignedTypesDF,
  showLegend = FALSE,
  sort = FALSE,
  las = 2,
  cex_names = 0.8
)
}
\arguments{
\item{assignedTypesDF}{A data frame, typically the output of \code{\link{assignTypes}},
containing at least the columns \code{query} and \code{assignedType}.}

\item{showLegend}{Logical; if \code{TRUE}, adds a legend mapping species
(A, B, C, Other) to colors. Default is \code{FALSE}.}

\item{sort}{Logical; if \code{TRUE}, bars are sorted descending by count. Default \code{FALSE}.}

\item{las}{Integer; axis label style for type names (defaults to 2 = perpendicular for readability).}

\item{cex_names}{Numeric; character expansion for x-axis names. Default 0.8.}
}
\value{
Invisibly returns a data frame with columns:
  \code{assignedType}, \code{count}, \code{species}.
}
\description{
Generates a barplot showing the frequency of assigned rhinovirus types.
Optionally displays a legend indicating species classification (A, B, C, Other).
}
\details{
Types are grouped into species via the first letter \emph{of the type token}
after stripping common prefixes like \code{"RV-"} or \code{"RV"}.
Any \code{"unassigned"} (any case) is labeled as species \code{"Other"}.

Colors:
\itemize{
  \item A = blue
  \item B = red
  \item C = green
  \item Other = grey
}
}
\examples{
test <- system.file("extdata", "input_aln.fasta", package = "rhinotypeR")
fastaD <- Biostrings::readDNAStringSet(test)
assigned <- try(assignTypes(fastaD), silent = TRUE)
if (!inherits(assigned, "try-error")) {
  plotFrequency(assigned, showLegend = TRUE)
}

}
\seealso{
\code{\link{assignTypes}}

Other visualization: 
\code{\link{SNPeek}()},
\code{\link{plotAA}()},
\code{\link{plotDistances}()},
\code{\link{plotTree}()}
}
\concept{visualization}
