% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_plotDistances.R
\name{plotDistances}
\alias{plotDistances}
\title{Plot Pairwise Distance Heatmap}
\usage{
plotDistances(distancesMatrix)
}
\arguments{
\item{distancesMatrix}{A numeric matrix of pairwise distances, usually
produced by \code{\link{pairwiseDistances}} or related functions.}
}
\value{
Invisibly returns the object from \code{stats::heatmap}
  (a list with components such as \code{rowInd} and \code{colInd}).
  The primary output is the heatmap drawn to the active device.
}
\description{
Generates a heatmap from a pairwise distance matrix, typically produced by
\code{\link{pairwiseDistances}}.
}
\details{
The function uses the base R \code{heatmap} function to visualize distances.
Row and column clustering are disabled to preserve the input ordering.

Colors are drawn from \code{heat.colors(256)}. The scale is set to "none"
so the distances are displayed directly, not normalized by row or column.
}
\examples{
# Example using built-in dataset
test <- system.file("extdata", "input_aln.fasta", package = "rhinotypeR")
fastaD <- Biostrings::readDNAStringSet(test)

# Compute pairwise distances
dist_mat <- pairwiseDistances(fastaD)

# Plot heatmap of distances
 plotDistances(dist_mat)
 
}
\seealso{
\code{\link{pairwiseDistances}}, \code{\link{plotTree}}

Other visualization: 
\code{\link{SNPeek}()},
\code{\link{plotAA}()},
\code{\link{plotFrequency}()},
\code{\link{plotTree}()}
}
\concept{visualization}
