% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_overallMeanDistance.R
\name{overallMeanDistance}
\alias{overallMeanDistance}
\title{Overall Mean Pairwise Distance}
\usage{
overallMeanDistance(
  fastaData,
  model = "IUPAC",
  deleteGapsGlobally = FALSE,
  ...
)
}
\arguments{
\item{fastaData}{A \link[Biostrings]{DNAStringSet} containing aligned nucleotide sequences.}

\item{model}{Character string specifying the substitution model to use.
Defaults to `"IUPAC"`. Other options are passed to \code{\link[ape]{dist.dna}}.}

\item{deleteGapsGlobally}{Logical; if \code{TRUE}, columns with gaps in any sequence
are removed before computing distances. Default is \code{FALSE}.}

\item{...}{Additional arguments passed to \code{\link[MSA2dist]{dnastring2dist}}.}
}
\value{
A single numeric value giving the overall mean pairwise distance
  across all sequence comparisons (excluding diagonal/self comparisons).
}
\description{
Computes the overall mean pairwise distance between all sequences
in an alignment. Optionally deletes columns containing gaps across all sequences
before computing the distances.
}
\details{
The function computes all pairwise distances using
\code{\link[MSA2dist]{dnastring2dist}}, extracts the distance matrix,
and reports the mean of the off-diagonal elements.
}
\examples{
# Load example alignment
test <- system.file("extdata", "input_aln.fasta", package = "rhinotypeR")
fastaD <- Biostrings::readDNAStringSet(test)

# Compute mean distance (using default IUPAC model)
overallMeanDistance(fastaD)

# Compute mean distance with gaps deleted
overallMeanDistance(fastaD, deleteGapsGlobally = TRUE)

}
\seealso{
\code{\link{pairwiseDistances}}, \code{\link{assignTypes}}
}
