# Data Description for `inst/extdata`

## `<input.aln>`
This file contains GenBank Accession numbers MT177659–MT177911, representing VP4/2 sequences previously generated by Luka et al. to study rhinovirus dynamics within a school setting.

### Source
- Luka, M. M. et al. Molecular epidemiology of human rhinovirus from one-year surveillance within a school setting in rural coastal Kenya. *Open Forum Infect. Dis.* 7, 2020.03.09.20033019 (2020).

### Licensing Information
- Usage of these sequences follows the terms and conditions specified by GenBank and the original publication (CC-BY).

### Creation Process
1. Downloaded accessions MT177659–MT177911 from GenBank using the specified accession numbers.
2. Aligned sequences using MAFFT.

---

## `<prototypes.fasta>` and `<prototypes.rds>`
These files contain prototype sequences downloaded from [Picornaviridae](https://picornaviridae.com), combined with sequences from Luka et al., and aligned using MAFFT.

### Source
- Prototype sequences from Picornaviridae.
- Additional sequences from Luka, M. M. et al.

### Licensing Information
- Prototype sequences are publicly available.
- Sequences from Luka et al. are also publicly available.

### Creation Process
1. Downloaded prototype sequences from [Picornaviridae](https://picornaviridae.com).
2. Combined with sequences from Luka et al.
3. Saved combined sequences as `prototypes.rds`.
4. Aligned all sequences using MAFFT.

---

## `<test.fasta>`
This file contains two reference sequences (AF343652.1_RVB99 and AY040238.1_RVB92) to create a lightweight file for demonstrating some functions.

### Source
- GenBank Accession numbers AF343652.1 and AY040238.1.

### Licensing Information
- Usage of these sequences follows the terms and conditions specified by GenBank.

### Creation Process
1. Downloaded sequences AF343652.1 and AY040238.1 from GenBank.
2. Combined these sequences into a single FASTA file for demonstration purposes.

---

## `<test.translated.fasta>`
This file contains the translated amino acid sequences from `test.fasta`.

### Source
- Derived from the `test.fasta` file.

### Licensing Information
- Follows the same licensing as `test.fasta`.

### Creation Process
1. Translated the nucleotide sequences in `test.fasta` to amino acids using a translation tool (e.g., AliView).

---

## References
1. Luka, M. M. et al. Molecular epidemiology of human rhinovirus from one-year surveillance within a school setting in rural coastal Kenya. *Open Forum Infect. Dis.* 7, 2020.03.09.20033019 (2020).

2. [GenBank](https://www.ncbi.nlm.nih.gov/genbank/)

3. Yamada, K. D. et al. Application of the MAFFT sequence alignment program to large data: reexamination of the usefulness of chained guide trees. *Bioinformatics*, 32:3246–51 (2016).

4. Larsson, A. AliView: a fast and lightweight alignment viewer and editor for large data sets. *Bioinformatics*, 30(22): 3276-3278 (2014).
