% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dataset.R
\docType{methods}
\name{getData}
\alias{getData}
\alias{getData,HSDSDataset,character,character-method}
\alias{getData,HSDSDataset,character,missing-method}
\alias{getData,HSDSDataset,list,character-method}
\alias{getData,HSDSDataset,list,missing-method}
\alias{getData,HSDSDataset,list,,missing-method}
\title{extract elements of a one or two-dimensional HSDSDataset}
\usage{
getData(dataset, indices, transfermode)

\S4method{getData}{HSDSDataset,character,character}(dataset, indices, transfermode)

\S4method{getData}{HSDSDataset,character,missing}(dataset, indices)

\S4method{getData}{HSDSDataset,list,character}(dataset, indices, transfermode)

\S4method{getData}{HSDSDataset,list,missing}(dataset, indices)
}
\arguments{
\item{dataset}{An object of type HSDSDataset, the dataset to access.}

\item{indices}{The indices of the data to fetch}

\item{transfermode}{Either 'JSON' or 'binary' (default)}
}
\value{
an Array containing the data fetched from the server
}
\description{
Fetch data from a remote dataset
}
\details{
The servers require data to be fetched in slices, i.e., in sets of 
for which the indices of each dimension are of the form start:stop:step.
More complex sets of indices will be split into slices and fetched in
multiple requests. This is opaque to the user, but may enter into 
considerations of data access patterns, e.g., for performance-tuning.
}
\examples{
if (check_hsds()) {
 s <- HSDSSource(URL_hsds())
 f <- HSDSFile(s, '/shared/bioconductor/patelGBMSC.h5')
 d <- HSDSDataset(f, '/assay001')
 x <- getData(d, c('1:4', '1:27998'), transfermode='JSON')
 xb <- getData(d, c('1:4', '1:27998'), transfermode='binary')
 # x <- getData(d, c(1:4, 1:27998), transfermode='JSON') # method missing?
 x 
 xb
}
}
