% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{tef}
\alias{tef}
\title{Function to get the Threshold for effective tests (TEF)}
\usage{
tef(object)
}
\arguments{
\item{object}{An \code{ExWAS} object}
}
\value{
A number indicating the efective threshold.
}
\description{
Function to get the Threshold for effective tests (TEF)
}
\examples{
data(exposome)
w1 <- exwas(expo[1:5, ], asthma~1, family = "binomial")
w2 <- exwas(expo[1:5, ], asthma~sex+age, family = "binomial")
tef(w1)
tef(w2)
}
\references{
Evaluating the effective numbers of independent tests and
significant p-value thresholds in commercial genotyping arrays and public
imputation reference datasets. Miao-Xin Li, Juilian M. Y. Yeung,
Stacey S. Cherny and Pak C. Sham. May 2012 Hum Genet.
}
\seealso{
\link{exwas} as a constructor for \link{ExWAS} objects
}
