% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{pca}
\alias{pca}
\title{Creation of an ExposomePCA from an ExposomeSet.}
\usage{
pca(object, npc = 10, pca = FALSE, ...)
}
\arguments{
\item{object}{\code{ExposomeSet} which exposures will be used for the PCA}

\item{npc}{(by default 10) number of dimensions kept in the results}

\item{pca}{(default \code{FALSE}) Set to \code{TRUE} to Perform PCA (only numerical variables) 
or \code{FALSE} to perform FAMD (numerical and categorical)}

\item{...}{Arguments to be passed to imputeFAMD}
}
\value{
An \code{ExposomePCA} with the values of the PCA.
}
\description{
Method to calculate a PCA based on the exposures of an \link{ExposomeSet}.
Only numerical-exposures (non categorical) will be computed. The
function resurns an \link{ExposomePCA} object. This PCA is performed
by using \link{FactoMineR} package.
}
\examples{
data("exposome")
epca <- pca(expo[12:20, ])
}
\seealso{
\link{plotPCA} to plot the PCA values of an
\link{ExposomePCA}, \link{clustering} to see how the exposures can
cluster samples, \link{correlation} to compute the correlation between
exposures
}
