% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{normalityTest}
\alias{normalityTest}
\title{It creates a \code{data.frame} of boolean indicating if the exposures follows
a normal distribution or not.}
\usage{
normalityTest(
  object,
  exposure,
  th = 0.05,
  min.val = 5,
  na.rm = TRUE,
  warnings = TRUE
)
}
\arguments{
\item{object}{\link{ExposomeSet} with the exposome to be tested.}

\item{exposure}{Name of the exposure to be tested, if missing all the
exposures will be tested.}

\item{th}{(by default \code{0.05}) Threshold to considere an exposure to
follow a normal distribution.}

\item{min.val}{(by default \code{5}) Minimum number of values not missings
to test the exposures.}

\item{na.rm}{(by default \code{TRUE}) Removes the NA values to test the
normality on the exposure.}

\item{warnings}{(by default: \code{TRUE}) Show warnings if required.}
}
\value{
A \code{data.frame} with three columns: exposure, normality and
p.value. "exposure" column contains the name of each exposure. "normalty"
column contains a \code{logical} value indicating if the obtained p-value
is under the given threshold. "p.value" column contains the obtained p-value
from \code{\link{shapiro.test}}.
}
\description{
This functions uses \code{\link{shapiro.test}} to test the normality of the
exposures and returns a \code{data.frame} with a boolean value and a
p-value for each exposure.
}
\examples{
data("exposome")
normalityTest(expo)
}
\seealso{
\link{plotHistogram} to draw the shape of an exposure,
\link{plotMissings} to draw a plot with the missing data an ExposomeSet,
\link{imputation} to impute missing data on the exposures of an ExposomeSet
}
