% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadImputed.R
\name{loadImputed}
\alias{loadImputed}
\title{Creation of an imExposomeSet from \code{data.frames}}
\usage{
loadImputed(
  data,
  description,
  description.famCol = "family",
  description.expCol = "exposure",
  exposures.asFactor = 5,
  warnings = TRUE
)
}
\arguments{
\item{data}{The \code{data.frame} of both exposures and phentoypes obtained
from \code{mice}.}

\item{description}{\code{data.frame} with the description of the exposures
(relation between exposures and exposure-family).}

\item{description.famCol}{(default \code{"family"}) Index where the family's
name (per exposures) if found in file "description". It can be both numeric
or character.}

\item{description.expCol}{(default \code{"exposures"}) Index where the
exposure's name if found in file "description". It can be both numeric
or character.}

\item{exposures.asFactor}{(default \code{5}) The exposures with more
than this number of unique items will be considered as "continuous" while
the exposures with less or equal number of items will be considered as
"factor".}

\item{warnings}{(default \code{TRUE}) If \code{TRUE} shows useful
information/warnings from the process of loading the exposome.}
}
\value{
An object of class \link{imExposomeSet}.
}
\description{
Given a \code{data.frame} from \code{code} with the multiple
imputations of both exposures and phenotypes, join with a \code{data.frame}
with exposures' description, and object of class \code{\link{imExposomeSet}}
is created.
}
\details{
The coordination of the information is based in the columns \code{.imp} and
\code{.id} from the \code{data.frame} obtained from \code{mice}. The
division of exposures and phenotypes is based in description
\code{data.frame}, that are the exposures. Hence, the elements in the
main \code{data.frame} that are not in the description, are the
phentoypes.
}
\examples{
data("me") # me is an imputed matrix of exposure and phenotyes
path <- file.path(path.package("rexposome"), "extdata")
description <- file.path(path, "description.csv")
dd <- read.csv(description, header=TRUE, stringsAsFactors=FALSE)
dd <- dd[dd$Exposure \%in\% colnames(me), ]
ex_imp <- loadImputed(data = me, description = dd,
description.famCol = "Family",
description.expCol = "Exposure")
}
\seealso{
\link{imExposomeSet} for class description
}
