% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{imputation}
\alias{imputation}
\title{Function to impute missing values from an ExposomeSet}
\usage{
imputation(object, select, ..., messages = FALSE)
}
\arguments{
\item{object}{\code{ExposomeSet} which exposures will be imputed.}

\item{select}{Exposures to be imputed. If missing, all exposes will be
imputed.}

\item{...}{Argument given to function \code{mice} of pakcage \code{mice}
(\code{printFlag} is set from \code{messages}).}

\item{messages}{(default \code{FALSE}) If set to \code{TRUE} messages from
\code{mice}'s function will be displayed.}
}
\value{
A new \code{ExposomeSet} with the imputed exposures.
}
\description{
This function is a wrapper of the functions \code{mice} and \code{complete}
from the package \code{mice}. Also to the \code{impute} from the
package \code{Hmisc}. The function is designed to use those functions
to impute missing values on exposures (not in phenotypes).
}
\examples{
\dontrun{
#Being x an ExposomeSet
x <- imputation(x)
}
}
\seealso{
\link{plotMissings} to plot the missing data of an ExposomeSet,
\link{tableMissings} to get a table with the missing data of an ExposomeSet
}
