% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{ilod}
\alias{ilod}
\title{Function to impute under-LOD values from an ExposomeSet}
\usage{
ilod(
  object,
  seed = 1234,
  lod.col = "LOD",
  pNA = 0.2,
  tLog = FALSE,
  method = "QRILC",
  warnings = TRUE,
  ...
)
}
\arguments{
\item{object}{\code{ExposomeSet} which exposures will be imputed.}

\item{seed}{(default \code{1234}) Seed to make the imputation reproducible.}

\item{lod.col}{(default \code{"LOD"}) Name of the column in \code{fData}
with the threshold of the LOD.}

\item{pNA}{(default \code{0.2}) Maximum percentage allowed of values under
LOD}

\item{tLog}{(default \code{FALSE}) If set to \code{TRUE} it transforms all
the exposures to lod before the imputation.}

\item{method}{(default \code{"QRILC"}) Method to be used to impute the
under-LOD values. Two allowed: QRILC method (value \code{"QRILC"}) and
stochastic minimal value approach (value \code{"MinProb"}).}

\item{warnings}{(default \code{TRUE}) If set to \code{FALSE} warnings will
not be displayed.}

\item{...}{Arguments passed to \code{impute.QRILC} or \link{impute.MinProb}
from \code{imputeLCMD}.}
}
\value{
A new \code{ExposomeSet} with the imputed exposures.
}
\description{
This function is a wrapper of the functions \code{impute.MinProb}
from the package \code{imputeLCMD}.
}
\examples{
\dontrun{
#Being x an ExposomeSet
x <- ilod(x)
}
}
\seealso{
\link{plotMissings} to plot the missing data of an ExposomeSet,
\link{tableMissings} to get a table with the missing data of an ExposomeSet
}
