% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_datasets.R
\name{list_datasets}
\alias{list_datasets}
\title{List available datasets in RegulonDB database}
\usage{
list_datasets(regulondb)
}
\arguments{
\item{regulondb}{A regulondb class.}
}
\value{
A \code{character()} with the names of the available datasets.
}
\description{
This function returns a vector of all available tables from a
regulondb class.
}
\examples{

## Connect to the RegulonDB database if necessary
if (!exists("regulondb_conn")) regulondb_conn <- connect_database()

## Build the regulon db object
e_coli_regulondb <-
    regulondb(
        database_conn = regulondb_conn,
        organism = "E.coli",
        database_version = "1",
        genome_version = "1"
    )

## List the available datasets
list_datasets(e_coli_regulondb)
}
\keyword{data}
\keyword{database}
\keyword{datasets}
\keyword{retrieval}
