% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.localZScoreResultsList.R
\name{plot.localZScoreResultsList}
\alias{plot.localZScoreResultsList}
\title{Plot a list of localZscore results}
\usage{
\method{plot}{localZScoreResultsList}(x, ncol = NA, main = "", num.x.labels = 5, ...)
}
\arguments{
\item{x}{an object of class \code{localZScoreResultsList}.}

\item{main}{a character specifying the main title of the plot. Defaults to no title.}

\item{num.x.labels}{a numeric specifying the number of ticks to label the x axis. The total number will be 2*num.x.labels + 1. Defaults to 5.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
A plot is created on the current graphics device.
}
\description{
Function for plotting the a \code{localZScoreResultsList} object.
}
\examples{

genome <- filterChromosomes(getGenome("hg19"), keep.chr="chr1")
A <- createRandomRegions(nregions=20, length.mean=10000000, length.sd=20000, genome=genome, non.overlapping=FALSE) 
B <- c(A, createRandomRegions(nregions=10, length.mean=100000, length.sd=20000, genome=genome, non.overlapping=FALSE))

pt <- overlapPermTest(A=A, B=B, ntimes=10, genome=genome, non.overlapping=FALSE)
 
lz <- localZScore(A=A, B=B, pt=pt)
plot(lz)

pt2 <- permTest(A=A, B=B, ntimes=10, randomize.function=randomizeRegions, evaluate.function=list(overlap=numOverlaps, distance=meanDistance), genome=genome, non.overlapping=FALSE)
plot(pt2)


}
\seealso{
\code{\link{localZScore}}
}
\keyword{internal}
