% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circularRandomizeRegions.R
\name{circularRandomizeRegions}
\alias{circularRandomizeRegions}
\title{Circular Randomize Regions}
\usage{
circularRandomizeRegions(A, genome="hg19", mask=NULL, max.mask.overlap=NULL, max.retries=10, verbose=TRUE, ...)
}
\arguments{
\item{A}{The set of regions to randomize. A region set in any of the accepted formats by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}

\item{genome}{The reference genome to use. A valid genome object. Either a \code{\link{GenomicRanges}} or \code{\link{data.frame}} containing one region per whole chromosome or a character uniquely identifying a genome in \code{\link{BSgenome}} (e.g. "hg19", "mm10" but not "hg"). Internally it uses \code{\link{getGenomeAndMask}}.}

\item{mask}{The set of regions specifying where a random region can not be (centromeres, repetitive regions, unmappable regions...). A region set in any of the accepted formats by \code{\link{toGRanges}} (\code{\link{GenomicRanges}},\code{\link{data.frame}}, ...). If \code{\link{NULL}} it will try to derive a mask from the genome (currently only works is the genome is a character string) and if \code{\link{NA}} it will explicitly give an empty mask.}

\item{max.mask.overlap}{numeric value}

\item{max.retries}{numeric value}

\item{verbose}{a boolean.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
It returns a \code{\link{GenomicRanges}} object with the regions resulting from the randomization process.
}
\description{
Given a set of regions A and a genome, this function returns a new set of regions created by applying a random
spin to each chromosome.
}
\details{
This randomization strategy is useful when the spatial relation between the regions in the RS is important and has to be conserved.
}
\examples{
A <- data.frame("chr1", c(1, 10, 20, 30), c(12, 13, 28, 40))

mask <- data.frame("chr1", c(20000000, 100000000), c(22000000, 130000000))

genome <- data.frame(c("chr1", "chr2"), c(1, 1), c(180000000, 20000000))

circularRandomizeRegions(A)

circularRandomizeRegions(A, genome=genome, mask=mask, per.chromosome=TRUE, non.overlapping=TRUE)

}
\seealso{
\code{\link{randomizeRegions}}, \code{\link{toDataframe}}, \code{\link{toGRanges}}, \code{\link{getGenome}}, \code{\link{getMask}}, \code{\link{getGenomeAndMask}}, \code{\link{characterToBSGenome}}, \code{\link{maskFromBSGenome}}, \code{\link{resampleRegions}}, \code{\link{createRandomRegions}}
}
