% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_geo.R
\name{find_geo}
\alias{find_geo}
\title{Find the GEO accession id for a given SRA run}
\usage{
find_geo(run, verbose = FALSE, sleep = 1/2)
}
\arguments{
\item{run}{A character vector of length 1 with the SRA run accession id.}

\item{verbose}{Whether to print a message for the run. Useful when looping
over a larger number of SRA run ids.}

\item{sleep}{The number of seconds (or fraction) to wait before downloading
data using \link[GEOquery:getGEO]{getGEO}. This is important if you are looking over
\code{geo_info()} given the constraints published at
\url{https://www.ncbi.nlm.nih.gov/books/NBK25497/}.}
}
\value{
The GEO accession id for the corresponding sample.
}
\description{
Given a SRA run id, this function will retrieve the GEO accession id
(starting with GSM) if it's available. Otherwise it will return \code{NA}.
}
\details{
Although the phenotype information already includes the GEO
accession ids, not all projects had GEO entries at the time these tables
were created. This function will then be useful to check if there is a GEO
accession id for a given sample (run). If there is, you can then retrieve
the information using \link{geo_info}.
}
\examples{
## Find the GEO accession id for for SRX110461
find_geo("SRX110461")
}
\author{
Leonardo Collado-Torres
}
