% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressed_regions.R
\name{expressed_regions}
\alias{expressed_regions}
\title{Identify expressed regions from the mean coverage for a given SRA project}
\usage{
expressed_regions(
  project,
  chr,
  cutoff,
  outdir = NULL,
  maxClusterGap = 300L,
  chrlen = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{project}{A character vector with one SRA study id.}

\item{chr}{A character vector with the name of the chromosome.}

\item{cutoff}{The base-pair level cutoff to use.}

\item{outdir}{The destination directory for the downloaded file(s) that were
previously downloaded with \link{download_study}. If the files are missing,
but \code{outdir} is specified, they will get downloaded first. By default
\code{outdir} is set to \code{NULL} which will use the data from the web.
We only recommend downloading the full data if you will use it several times.}

\item{maxClusterGap}{This determines the maximum gap between candidate ERs.}

\item{chrlen}{The chromosome length in base pairs. If it's \code{NULL}, the
chromosome length is extracted from the Rail-RNA runs GitHub repository.
Alternatively check the \code{SciServer} section on the vignette to see
how to access all the recount data via a R Jupyter Notebook.}

\item{verbose}{If \code{TRUE} basic status updates will be printed along the
way.}

\item{...}{Additional arguments passed to \link{download_study} when
\code{outdir} is specified but the required files are missing.}
}
\value{
A \link[GenomicRanges:GRanges-class]{GRanges-class} object as created by
\link[derfinder:findRegions]{findRegions}.
}
\description{
This function uses the pre-computed mean coverage for a given SRA project to
identify the expressed regions (ERs) for a given chromosome. It returns a
\link[GenomicRanges:GRanges-class]{GRanges-class} object with the expressed regions as
defined by \link[derfinder:findRegions]{findRegions}.
}
\examples{
## Define expressed regions for study SRP002001, chrY

## Workaround for https://github.com/lawremi/rtracklayer/issues/83
download_study("SRP002001", type = "mean")

regions <- expressed_regions("SRP002001", "chrY",
    cutoff = 5L,
    maxClusterGap = 3000L,
    outdir = "SRP002001"
)

\dontrun{
## Define the regions for multiple chrs
regs <- sapply(chrs, expressed_regions, project = "SRP002001", cutoff = 5L)

## You can then combine them into a single GRanges object if you want to
library("GenomicRanges")
single <- unlist(GRangesList(regs))
}

}
\seealso{
\link{download_study}, \link[derfinder:findRegions]{findRegions},
\link[derfinder:railMatrix]{railMatrix}
}
\author{
Leonardo Collado-Torres
}
