% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_matrix.R
\name{coverage_matrix}
\alias{coverage_matrix}
\title{Given a set of regions for a chromosome, compute the coverage matrix for a
given SRA study.}
\usage{
coverage_matrix(
  project,
  chr,
  regions,
  chunksize = 1000,
  bpparam = NULL,
  outdir = NULL,
  chrlen = NULL,
  verbose = TRUE,
  verboseLoad = verbose,
  scale = TRUE,
  round = FALSE,
  ...
)
}
\arguments{
\item{project}{A character vector with one SRA study id.}

\item{chr}{A character vector with the name of the chromosome.}

\item{regions}{A \link[GenomicRanges:GRanges-class]{GRanges-class} object with regions
for \code{chr} for which to calculate the coverage matrix.}

\item{chunksize}{A single integer vector defining the chunksize to use for
computing the coverage matrix. Regions will be split into different chunks
which can be useful when using a parallel instance as defined by
\code{bpparam}.}

\item{bpparam}{A \link[BiocParallel:BiocParallelParam-class]{BiocParallelParam-class} instance which
will be used to calculate the coverage matrix in parallel. By default,
\link[BiocParallel:SerialParam-class]{SerialParam-class} will be used.}

\item{outdir}{The destination directory for the downloaded file(s) that were
previously downloaded with \link{download_study}. If the files are missing,
but \code{outdir} is specified, they will get downloaded first. By default
\code{outdir} is set to \code{NULL} which will use the data from the web.
We only recommend downloading the full data if you will use it several times.}

\item{chrlen}{The chromosome length in base pairs. If it's \code{NULL}, the
chromosome length is extracted from the Rail-RNA runs GitHub repository.
Alternatively check the \code{SciServer} section on the vignette to see
how to access all the recount data via a R Jupyter Notebook.}

\item{verbose}{If \code{TRUE} basic status updates will be printed along the
way.}

\item{verboseLoad}{If \code{TRUE} basic status updates for loading the data
will be printed.}

\item{scale}{If \code{TRUE}, the coverage counts will be scaled to read
counts based on a library size of 40 million reads. Set \code{scale} to
\code{FALSE} if you want the raw coverage counts. The scaling method is by
AUC, as in the default option of \link{scale_counts}.}

\item{round}{If \code{TRUE}, the counts are rounded to integers. Set to
\code{TRUE} if you want to match the defaults of \link{scale_counts}.}

\item{...}{Additional arguments passed to \link{download_study} when
\code{outdir} is specified but the required files are missing.}
}
\value{
A \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
object with the counts stored in the assays slot.
}
\description{
Given a set of genomic regions as created by \link{expressed_regions}, this
function computes the coverage matrix for a library size of 40 million 100 bp
reads for a given SRA study.
}
\details{
When using \code{outdir = NULL} the information will be accessed
from the web on the fly. If you encounter internet access problems, it might
be best to first download the BigWig files using \link{download_study}. This
might be the best option if you are accessing all chromosomes for a given
project and/or are thinking of using different sets of \code{regions} (for
example, from different cutoffs applied to \link{expressed_regions}).
Alternatively check the \code{SciServer} section on the vignette to see
how to access all the recount data via a R Jupyter Notebook.

If you have \code{bwtool} installed, you can use
\url{https://github.com/LieberInstitute/recount.bwtool} for faster results.
Note that you will need to run \link{scale_counts} after running
\code{coverage_matrix_bwtool()}.
}
\examples{

## Workaround for https://github.com/lawremi/rtracklayer/issues/83
download_study("SRP002001", type = "mean")
download_study("SRP002001", type = "samples")

## Define expressed regions for study DRP002835, chrY
regions <- expressed_regions("SRP002001", "chrY",
    cutoff = 5L,
    maxClusterGap = 3000L,
    outdir = "SRP002001"
)

## Now calculate the coverage matrix for this study
rse <- coverage_matrix("SRP002001", "chrY", regions, outdir = "SRP002001")

## One row per region
identical(length(regions), nrow(rse))
}
\seealso{
\link{download_study}, \link[derfinder:findRegions]{findRegions},
\link[derfinder:railMatrix]{railMatrix}
}
\author{
Leonardo Collado-Torres
}
