% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_plotNull.R
\name{plotNull}
\alias{plotNull}
\title{Plot the obtained null distribution along with a histogram of observed test
statistics}
\usage{
plotNull(
  fit,
  lowColor = "yellow",
  highColor = "blue",
  idNull = NULL,
  nResampleCurves = length(fit$Weights),
  hSize = 0.5
)
}
\arguments{
\item{fit}{an object returned by the reconsi() (or testDAA()) function}

\item{lowColor, highColor}{The low and high ends of the colour scale}

\item{idNull}{indices of known null taxa}

\item{nResampleCurves}{The number of resampling null distributions to plot}

\item{hSize}{A double, the size of the line of the collapsed null estimate}
}
\value{
a ggplot2 plot object
}
\description{
Plot the obtained null distribution along with a histogram of observed test
statistics
}
\examples{
 p = 180; n = 50; B = 1e2
 #Low number of resamples keeps computation time down
 x = rep(c(0,1), each = n/2)
 mat = cbind(
 matrix(rnorm(n*p/10, mean = 5+x),n,p/10), #DA
 matrix(rnorm(n*p*9/10, mean = 5),n,p*9/10) #Non DA
 )
#Provide just the matrix and grouping factor, and test using the random null
fdrRes = reconsi(mat, x, B = B)
plotNull(fdrRes)
}
