% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrapeReferences.R
\name{scrapeReferences}
\alias{scrapeReferences}
\title{Scrape references from a \pkg{bookdown} directory}
\usage{
scrapeReferences(dir, input = "index.Rmd", workdir = tempfile(), clean = TRUE)
}
\arguments{
\item{dir}{String containing a path to a \pkg{bookdown}-containing directory.}

\item{input}{String containing the name of the file to use in the \code{\link[bookdown]{render_book}} statement.}

\item{workdir}{String containing a path to a working directory to use to store bits and pieces.}

\item{clean}{Logical scalar indicating whether the working directory should be removed upon function completion.}
}
\value{
A data.frame where each row corresponds to a reference.
It has \code{id}, the name of the reference;
\code{file}, the compiled HTML file that the reference comes from;
and \code{text}, the text to be associated with that reference.
}
\description{
Scrape references to sections and figures from all Rmarkdown files in a \pkg{bookdown} directory.
}
\details{
This function works by performing a quick dummy compilation of the book, turning off all evaluations with a global \code{eval=FALSE}.
It then trawls the set of newly created HTML files, pulling out the section/figure identifiers and collating them into a data.frame.

The goal is to facilitate convenient linking between books by automatically filling in the file and text for a given link.
Packages that deploy books should run this in their \code{configure} scripts to obtain a reference mapping that they can serve to other packages via \code{\link{link}}.

Extraction of the figure text assumes that the figure prefix ends with a non-numeric character, e.g., \code{"Figure "} or \code{"Figure S"}.
}
\examples{
book.dir <- system.file("example", package="rebook")
df <- scrapeReferences(book.dir)
df
}
\seealso{
\code{\link{link}}, to create links given a package name and identifier.
}
\author{
Aaron Lun
}
