% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMakefile.R
\name{createMakefile}
\alias{createMakefile}
\title{Create a compilation Makefile}
\usage{
createMakefile(dir = ".", pattern = "\\\\.Rmd$", ..., fname = "Makefile")
}
\arguments{
\item{dir}{String containing the path to the directory containing Rmarkdown reports.
This is searched recursively for all files ending in \code{".Rmd"}.}

\item{...}{Further arguments to pass to \code{\link{buildChapterGraph}}.}

\item{fname}{String containing the name of the output Makefile.}
}
\value{
A Makefile is created in \code{dir} with the name \code{fname}
and a \code{NULL} is invisibly returned.
}
\description{
Create a Makefile for compiling individual chapters, 
in a manner that respects the dependencies between chapters.
}
\details{
The main benefit of using a Makefile is that the generation of the chapter caches can be done in parallel.
Then, the \pkg{bookdown} step can just serially retrieve the cache contents for rapid rendering. 

The Makefile uses the markdown output file as an indicator of successful \code{\link{knit}}ting of a chapter.
Caches are left in the current working directory after the compilation of each report.
It is assumed that \pkg{bookdown}'s \code{render_book} is smart enough to find and use these caches.
}
\examples{
dir <- tempfile()
dir.create(dir)

tmp1 <- file.path(dir, "alpha.Rmd")
write(file=tmp1, "```{r, echo=FALSE, results='asis'}
rebook::chapterPreamble()
```

```{r}
rodan <- 1
```")

tmp2 <- file.path(dir, "bravo.Rmd")
write(file=tmp2, "```{r, echo=FALSE, results='asis'}
rebook::chapterPreamble()
```

```{r}
extractCached('alpha.Rmd')
```")

# Creating the Makefile:
createMakefile(dir)
cat(readLines(file.path(dir, "Makefile")), sep="\n")

}
\seealso{
\code{\link{buildChapterGraph}}, to detect dependencies between chapters.
}
\author{
Aaron Lun
}
