% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patternComparison.R
\name{patternComparison}
\alias{patternComparison}
\title{Compare an input pattern against a set of patterns.}
\usage{
patternComparison(pattern, profileMatrixList, method = "pearson")
}
\arguments{
\item{pattern}{An N element input pattern specified as either a named vector or an
1 x N matrix or data frame.  Names (or column names) must match the column names of each element
of profileMatrixList.}

\item{profileMatrixList}{A single matrix (or data frame) or a list of matrices (or data frames).
Each matrix (data frame) must be k x N - that is the k patterns for comparison with the input
pattern must be specified along the rows, with rownames set appropriately.}

\item{method}{a string specifying the type of correlation, chosen from pearson 
(default) or spearman.}
}
\value{
A data frame with pattern comparison results. Specifically, if M is the total number
patterns in profileMatrixList elements, an M x 2 matrix is returned with sorted Pearson's 
correlations in the first column and corresponding p-values in the second column. Comparison
pattern names are indicated in the row names.
}
\description{
Compare an input pattern against a set of patterns.
}
\examples{
drugAct <- exprs(getAct(rcellminerData::drugData))
molDataMats <- getMolDataMatrices()[c("exp", "mut")]
molDataMats <- lapply(molDataMats, function(X) X[1:10, ])
pcResults <- patternComparison(drugAct["609699", ], molDataMats)
pcResults <- patternComparison(drugAct["609699", ], molDataMats, method="spearman")
pcResults <- patternComparison(drugAct["609699", ], molDataMats$exp, method="spearman")

}
\concept{rcellminer}
