% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDrugActivityRepeatData.R
\name{getDrugActivityRepeatData}
\alias{getDrugActivityRepeatData}
\title{Returns a matrix containing repeat activity experiment data for a compound.}
\usage{
getDrugActivityRepeatData(
  nscStr,
  concFormat = "NegLogGI50M",
  onlyCellMinerExps = TRUE
)
}
\arguments{
\item{nscStr}{a string specifying the NSC identifier for the compound.}

\item{concFormat}{a string selected from "NegLogGI50M" or "IC50MicroM".
"NegLogGI50M" specifies activities as the negative log of the 50% growth
inhibitory concentration (molar). "IC50MicroM" specifies activities as the 50% 
growth inhibitory concentration (micromolar).}

\item{onlyCellMinerExps}{a logical value indicating whether to only return
experimental data included in CellMiner (default=TRUE).}
}
\value{
a matrix with activity data from each experiment associated with 
a compound organized along the rows.
}
\description{
Returns a matrix containing repeat activity experiment data for a compound.
}
\examples{
nscStr <- "609699"
actData <- getDrugActivityRepeatData(nscStr, concFormat='NegLogGI50M')
actData <- getDrugActivityRepeatData(nscStr, concFormat='IC50MicroM')

}
\concept{rcellminer}
