/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.utils;

import edu.msu.cme.rdp.classifier.TrainingDataException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class HierarchyVersion {
    private static final String regex = "<trainsetNo>(.*)</trainsetNo><version>(.*)</version>";
    private Matcher matcher;
    private static Pattern versionPattern;
    private String version;
    private int trainsetNo;

    public HierarchyVersion(String doc) throws TrainingDataException {
        if (doc != null) {
            this.matcher = versionPattern.matcher(doc);
            try {
                if (this.matcher.find()) {
                    this.trainsetNo = Integer.parseInt(this.matcher.group(1).trim());
                    this.version = this.matcher.group(2);
                }
            }
            catch (NumberFormatException ex) {
                throw new TrainingDataException("Error: The trainsetNo should be integer in the header:" + doc);
            }
        }
    }

    public int getTrainsetNo() {
        return this.trainsetNo;
    }

    public String getVersion() {
        return this.version;
    }

    public static void main(String[] args) throws TrainingDataException {
        String doc = "<trainsetNo>1</trainsetNo><version>Bergey's Manual of Systematic Bacteriology v_3_mod_1</version><file>bergeyTree</file>";
        HierarchyVersion version = new HierarchyVersion(doc);
        String v = version.getVersion();
        int trainsetNo = version.getTrainsetNo();
        System.out.println("version =" + v + "* trainset no = " + trainsetNo + "*");
    }

    static {
        try {
            versionPattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException pse) {
            System.out.println("There is a problem with the regular expression! <trainsetNo>(.*)</trainsetNo><version>(.*)</version>");
        }
    }
}

