% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway2Graph.R
\name{pathway2Graph}
\alias{pathway2Graph}
\title{This function generates a directed graph from all the interactions of a specified pathway in a biopax model. Edges with no direction are indicated by a 0 weight.}
\usage{
pathway2Graph(
  biopax,
  pwid,
  expandSubpathways = TRUE,
  splitComplexMolecules = FALSE,
  useIDasNodenames = TRUE,
  verbose = FALSE,
  withDisconnectedParts = TRUE
)
}
\arguments{
\item{biopax}{A biopax model}

\item{pwid}{string}

\item{expandSubpathways}{logical. If TRUE subpathways are expanded into this graph, otherwise only this very pathway is used.}

\item{splitComplexMolecules}{logical. If TRUE every complex is split up into its components. This leads to splitting a single node with name of the complex into several nodes with names of the components, these components all have identical edges. Default value is FALSE}

\item{useIDasNodenames}{logical. If TRUE nodes of the graph are named by their molecule IDs instead of using the NAME property. This can help with badly annotated/formatted databases.}

\item{verbose}{logical}

\item{withDisconnectedParts}{logical. If TRUE the pathway graph is returned as such, else only the largest connected component is given back}
}
\value{
Returns the a graph object of the specified pathway. Edges with no direction are indicated by a 0 weight.
}
\description{
This function generates a directed graph from all the interactions of a specified pathway in a biopax model. Edges with no direction are indicated by a 0 weight.
}
\examples{
 # load data
data(biopaxLevel3Example) # location of the data
pwid <- "Pathway1019"
# build pathway using pathway2Graph
pathwayAsGraph <- pathway2Graph(biopax = biopaxLevel3Example, pwid = pwid, splitComplexMolecules = FALSE, useIDasNodenames = TRUE, verbose = FALSE, withDisconnectedParts = TRUE)
pathwayAsGraph # should have 23 nodes, 24 edges
plotRegulatoryGraph(pathwayAsGraph)
# build pathway discarding the disconnected parts of the graph
pathwayAsGraph <- pathway2Graph(biopax = biopaxLevel3Example, pwid = pwid, splitComplexMolecules = FALSE, useIDasNodenames = TRUE, verbose = FALSE, withDisconnectedParts = FALSE)
pathwayAsGraph # should have 10 nodes, 11 edges
plotRegulatoryGraph(pathwayAsGraph)
}
\author{
Nirupama Benis
}
