% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifyBiopax.R
\name{addPathwayComponents}
\alias{addPathwayComponents}
\title{This function adds pathway components to an existing pathway}
\usage{
addPathwayComponents(biopax, id, PATHWAY_COMPONENTS = c())
}
\arguments{
\item{biopax}{A biopax model}

\item{id}{string. ID for the pathway}

\item{PATHWAY_COMPONENTS}{character vector. IDs of the pathway components. This must be IDs of instances of type interaction/pathway/pathwayStep (or their subclasses).}
}
\value{
Returns the biopax model with the pathway components added to the pathway
}
\description{
This function adds pathway components to an existing pathway.
Property PATHWAY-COMPONENTS  are references to IDs of interaction/pathways/pathwaySteps (or subclasses of those)
}
\examples{
biopax = createBiopax(level=2)
biopax = addPhysicalEntity(biopax, class="protein", id="p_id1", NAME="protein1")
biopax = addPhysicalEntityParticipant(biopax, "p_id1", id="PEP_p_id1")
biopax = addPhysicalEntity(biopax, class="protein", id="p_id2", NAME="protein2")
biopax = addPhysicalEntityParticipant(biopax, "p_id2", id="PEP_p_id2")
biopax = addBiochemicalReaction(biopax, LEFT=c("PEP_p_id1"), RIGHT=c("PEP_p_id2"), id="biochem_id_1")
biopax = addPhysicalEntity(biopax, class="protein", id="p_id3", NAME="controllerProtein1")
biopax = addPhysicalEntityParticipant(biopax, "p_id3", id="PEP_p_id3")
biopax = addControl(biopax, CONTROL_TYPE="ACTIVATION", CONTROLLER="PEP_p_id3", CONTROLLED="biochem_id_1", id="c_id1")
biopax = addPathway(biopax, NAME="mypathway1", PATHWAY_COMPONENTS=c(), id="pw_id1")
biopax = addPathwayComponents(biopax, id="pw_id1", PATHWAY_COMPONENTS=c("c_id1"))
biopax$dt
}
\author{
fkramer
}
