% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeFeatures-functions.R
\name{removeRSD}
\alias{removeRSD}
\title{Feature Filtering based on RSD}
\usage{
removeRSD(x, qc_samples, cut = 0.3)
}
\arguments{
\item{x}{A matrix-like object.}

\item{qc_samples}{A vector of sample names or column indices specifying QC
samples for the calculation of RSD. Must be a subset of
\code{colnames(x)} if it is a character vector.}

\item{cut}{A numeric value between specifying a RSD cut-off to retain a
feature.}
}
\value{
A matrix containing the filtered features.
}
\description{
Removes Features with low reproducibility based on a relative standard
deviation (also known as coefficient of variation) of QC samples using the
data matrix where rows represent features and columns represent samples.
Features with a RSD above a cut-off will be removed from the data.
}
\examples{

set.seed(1e7)

m_bio <- matrix(rlnorm(800, sdlog = 1), ncol = 20)
m_qc <- matrix(rlnorm(400, sdlog = 0.25), ncol = 10)
m <- cbind(m_bio, m_qc)
colnames(m) <- c(paste0("S", seq_len(20)), paste0("Q", seq_len(10)))

removeRSD(m, qc_samples = paste0("Q", seq_len(10)))

}
\seealso{
See \link{removeFeatures} that provides a
\linkS4class{SummarizedExperiment}-friendly wrapper for this function.
}
