% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceFeatures-methods.R
\name{reduceFeatures}
\alias{reduceFeatures}
\alias{reduceFeatures,ANY-method}
\alias{reduceFeatures,SummarizedExperiment-method}
\title{Dimension reduction methods}
\usage{
\S4method{reduceFeatures}{ANY}(x, method = c("pca", "tsne", "plsda"), ncomp = 2, y, ...)

\S4method{reduceFeatures}{SummarizedExperiment}(x, method = c("pca", "tsne", "plsda"), ncomp = 2, i, y, ...)
}
\arguments{
\item{x}{A matrix-like object or \linkS4class{SummarizedExperiment} object.}

\item{method}{A string specifying which dimension-reduction method to use.}

\item{ncomp}{A integer specifying the number of components extract.}

\item{y}{A factor vector for the information about each sample's group.}

\item{...}{Arguments passed to a specific dimension-reduction method.}

\item{i}{A string or integer value specifying which assay values to use
when \code{x} is a SummarizedExperiment object.}
}
\value{
A matrix containing custom attributes related to the
dimension-reduction method used.
}
\description{
Performs dimensionality reduction on a matrix-like object or
\linkS4class{SummarizedExperiment} object.
}
\details{
Currently, principal component analysis (PCA), t-distributed stochastic
neighbor embedding (t-SNE), and partial least squares-discriminant analysis
(PLS-DA) are supported. For the method argument,

\code{pca} performs PCA using singular value decomposition. If there is any
missing value, the non-linear iterative partial least squares (NIPALS)
algorithm is used instead using the \link[pcaMethods:nipalsPca]{pcaMethods::nipalsPca}. See \link{reducePCA}
for details.

\code{tsne} performs t-SNE using the \link[Rtsne:Rtsne]{Rtsne::Rtsne}. See \link{reduceTSNE} for
details.

\code{plsda} performs PLS-DA using a standard PLS model for classification with
the \link[pls:mvr]{pls::plsr}. See \link{reducePLSDA} for details.
}
\examples{

data(faahko_se)

## SummarizedExperiment object
res_pca <- reduceFeatures(faahko_se, i = "knn_vsn", method = "pca")
summary(res_pca)

## Matrix
y <- factor(colData(faahko_se)$sample_group)
m <- assay(faahko_se, i = "knn_vsn")
res_plsda <- reduceFeatures(m, method = "plsda", y = y, ncomp = 3)
summary(res_plsda)

}
\references{
Wold, H. (1966). Estimation of principal components and related models by
iterative least squares. In P. R. Krishnajah (Ed.), Multivariate analysis
(pp. 391-420). NewYork: Academic Press.

Stacklies, W., Redestig, H., Scholz, M., Walther, D. and Selbig, J.
pcaMethods -- a Bioconductor package providing PCA methods for incomplete
data. Bioinformatics, 2007, 23, 1164-1167

L.J.P. van der Maaten and G.E. Hinton. Visualizing High-Dimensional Data
Using t-SNE. Journal of Machine Learning Research 9(Nov):2579-2605, 2008.

L.J.P. van der Maaten. Accelerating t-SNE using Tree-Based Algorithms.
Journal of Machine Learning Research 15(Oct):3221-3245, 2014.

Jesse H. Krijthe (2015). Rtsne: T-Distributed Stochastic Neighbor Embedding
using a Barnes-Hut Implementation, URL: https://github.com/jkrijthe/Rtsne

Kristian Hovde Liland, Bjørn-Helge Mevik and Ron Wehrens (2021). pls:
Partial Least Squares and Principal Component Regression. R package version
2.8-0. https://CRAN.R-project.org/package=pls
}
\seealso{
See \link{reducePCA}, \link{reduceTSNE}, and \link{reducePLSDA} for the underlying
functions that do the work.
}
