##' @details
##'
##' The qmtools package provides six categories of important functions:
##'
##'  - Imputation: the [imputeIntensity] function performs data imputation on
##'  missing values.
##'  - Normalization: the [normalizeIntensity] function performs data-driven
##'  normalization on metabolomics data.
##'  - Feature filtering: the [removeFeatures] function removes uninformative
##'  features based on missing values, QC and blank samples.
##'  - Feature clustering: the [clusterFeatures] function clusters metabolic
##'  features according to their retention time and intensity correlation.
##'  - Dimension-reduction: the [reduceFeatures] function performs
##'  dimensionality reduction.
##'  - Visualization: the [plotBox], [plotCorr], [plotMiss], [plotReduced], and
##'  [plotRTgroup] functions help to visualize metabolomics data.
##'
##' Please refer to the vignette to see how the aforementioned functions work.
##'
##' @keywords internal
##'
"_PACKAGE"
