% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrPlot.R
\name{corrPlot}
\alias{corrPlot}
\title{Correlation plot}
\usage{
corrPlot(
  MSnSetObj,
  addValues = TRUE,
  title = "",
  low_cor_colour = "#FFFFFF",
  high_cor_colour = "#B90505",
  low_cor_limit = 0,
  high_cor_limit = 1,
  textsize = 3
)
}
\arguments{
\item{MSnSetObj}{MSnSet; an object of class MSnSet}

\item{addValues}{logical: adds correlation values to the plot}

\item{title}{character; title of the plot}

\item{low_cor_colour}{colour; colour for lowest correlation in scale}

\item{high_cor_colour}{colour; colour for highest correlation in scale}

\item{low_cor_limit}{numeric; lower limit for correlation in colour scale}

\item{high_cor_limit}{numeric; upper limit for correlation in colour scale}

\item{textsize}{integer: set the size of correlation values text}
}
\value{
An object created by \code{ggplot}
}
\description{
Computes and display correlation plot for samples within MSnSet
}
\examples{

data(human_anno)
data(exp3_OHT_ESR1)
MSnSet_data <- convertToMSnset(exp3_OHT_ESR1$intensities_qPLEX1,
    metadata=exp3_OHT_ESR1$metadata_qPLEX1,
    indExpData=c(7:16), 
    Sequences=2, 
    Accessions=6)
corrPlot(MSnSet_data, addValues=TRUE, title="Correlation plot")

# change colours
corrPlot(MSnSet_data, addValues=TRUE, title="Correlation plot", 
    low_cor_colour="yellow", high_cor_colour="pink")

}
