% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/writeEset.R
\name{writeEset}
\alias{writeEset}
\alias{writeEset,ExpressionSet-method}
\title{Exporting an ExpressionSet instance into 3 tabulated files 'dataMatrix.tsv',
sampleMetadata.tsv', and 'variableMetadata.tsv'}
\usage{
writeEset(x, dirName, overwrite = FALSE, verbose = TRUE)

\S4method{writeEset}{ExpressionSet}(x, dirName, overwrite = FALSE, verbose = TRUE)
}
\arguments{
\item{x}{An S4 object of class \code{ExpressionSet}}

\item{dirName}{Character: directory where the tables should be written}

\item{overwrite}{Logical: should existing files be overwritten?}

\item{verbose}{Logical: should messages be printed?}
}
\value{
No object returned.
}
\description{
Note that the \code{dataMatrix} is transposed before
export (e.g., the samples are written column wise in the 'dataMatrix.tsv'
exported file).
}
\examples{
library(ptairData)
dirRaw <- system.file("extdata/exhaledAir", package = "ptairData")
exhaledPtrset <- createPtrSet(dir=dirRaw, setName="exhaledPtrset", 
mzCalibRef = c(21.022, 60.0525), fracMaxTIC = 0.7, saveDir = NULL )
exhaledPtrset<-detectPeak(exhaledPtrset,mz=c(21,59,77))
eset <- ptairMS::alignSamples(exhaledPtrset ) 
writeEset(eset, dirName = file.path(getwd(), "processed_dataset"))
unlink(file.path(getwd(), "processed_dataset"),recursive = TRUE)
}
