% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{updatePtrSet}
\alias{updatePtrSet}
\title{update a ptrSet object}
\usage{
updatePtrSet(ptrset)
}
\arguments{
\item{ptrset}{a ptrset object}
}
\value{
teh same ptrset object than ininput, but completed with new files 
and without deleted files in the directory
}
\description{
When new files are added to a directory which has already a ptrSet object 
associated, run \code{updatePtrSet} to add the new files in the object. 
The information on the new files are added to object with the same parameter 
used for the function \code{createPtrSet} who has created the object.
\code{updatePtrSet} also delete from the ptrSet deleted files in the directory.
}
\examples{
dirRaw <- system.file("extdata/exhaledAir", package = "ptairData")
exhaledPtrset <- createPtrSet(dir=dirRaw, setName="exhaledPtrset", 
mzCalibRef = c(21.022, 60.0525), fracMaxTIC = 0.7, saveDir = NULL )
##add or delete files in the directory 
# exhaledPtrset<- updatePtrSet(exhaledPtrset)
}
